import os
import shutil
from PIL import Image

def process_images():
    # 1. List the folders in the current directory
    folders = [folder for folder in os.listdir() if os.path.isdir(folder)]
    for index, folder in enumerate(folders, 1):
        print(f"{index}. {folder}")
    selected_index = int(input("Pick a folder number: ")) - 1
    selected_folder = folders[selected_index]

    # 2. Change directory to the chosen folder
    os.chdir(selected_folder)

    # 3. Look for image files
    extensions = ('.png', '.jpeg', '.jpg')
    image_files = [file for file in os.listdir() if file.lower().endswith(extensions)]

    if len(image_files) < 4:
        print("There should be at least 4 image files in the folder.")
        exit()

    # 4. Get dimensions of each image and add 5 pixel black border
    dimensions = []
    for image_file in image_files[:4]:  # Only first 4 images are considered
        with Image.open(image_file) as img:
            img = ImageOps.expand(img, border=5, fill='black')
            dimensions.append(img.size)
            img.save(image_file)

    avg_width = sum([dim[0] for dim in dimensions]) // 4
    avg_height = sum([dim[1] for dim in dimensions]) // 4

    # 5. Create new borderw and borderh variables
    borderw, borderh = 50, 50

    # 6. Create the new image
    canvas_width = 2 * avg_width + 3 * borderw
    canvas_height = 2 * avg_height + 3 * borderh

    canvas = Image.new("RGB", (canvas_width, canvas_height), "white")

    for index, image_file in enumerate(image_files[:4]):
        with Image.open(image_file) as img:
            row = index // 2
            col = index % 2
            x_offset = col * avg_width + (col + 1) * borderw
            y_offset = row * avg_height + (row + 1) * borderh
            canvas.paste(img, (x_offset, y_offset))

    # 7. Save the image
    os.chdir('..')  # Go up one directory level
    canvas.save(f"{selected_folder}.png")

    print(f"Image grid saved as {selected_folder}.png in {os.getcwd()}")

    # Ask to copy the image to Chapter folder
    response = input("Do you want to copy the resulting image to the Chapter folder? (Press ENTER for yes or 'N' to skip): ").strip().lower()
    if not response or response != 'n':
        parent_directory = os.path.abspath(os.path.join(os.getcwd(), os.pardir))
        shutil.copy(f"{selected_folder}.png", parent_directory)

    # Ask to process another folder
    response = input("Do you want to process another folder? (Press ENTER for yes or 'N' to exit): ").strip().lower()
    if not response or response == 'n':
        return False
    return True

while True:
    if not process_images():
        break
